<div id="sidebar" class="active">
    <div class="sidebar-wrapper active">
        <div class="sidebar-header position-relative">
            <div class="d-flex justify-content-center">
                <div class="logo">
                    <a href="<?php echo e(url('home')); ?>">
                        <img src="<?php echo e(url('assets/images/logo/' . (system_setting('company_logo') ?? null))); ?>" alt="Logo" srcset="">
                    </a>
                </div>
            </div>
        </div>
        <div class="sidebar-menu">
            <ul class="menu">

                
                <?php if(has_permissions('read', 'dashboard')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('home')); ?>" class='sidebar-link'>
                            <i class="bi bi-grid-fill"></i>
                            <span class="menu-item"><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'facility')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('parameters')); ?>" class='sidebar-link'>
                            <i class="bi bi-x-diamond"></i>
                            <span class="menu-item"><?php echo e(__('Facilities')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'categories')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('categories')); ?>" class='sidebar-link'>
                            <i class="fas fa-align-justify"></i>
                            <span class="menu-item"><?php echo e(__('Categories')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'near_by_places')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('outdoor_facilities')); ?>" class='sidebar-link'>
                            <i class="bi bi-geo-alt"></i>
                            <span class="menu-item"><?php echo e(__('Near By Places')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'customer')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('customer')); ?>" class='sidebar-link'>
                            <i class="bi bi-person-circle"></i>
                            <span class="menu-item"><?php echo e(__('Customer')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>


                
                <?php if(has_permissions('read', 'verify_customer_form') || has_permissions('read', 'approve_agent_verification')): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-person-check"></i>
                            <span class="menu-item"><?php echo e(__('Verify Agent')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">

                            
                            <?php if(has_permissions('read', 'verify_customer_form')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('verify-customer.form')); ?>"><?php echo e(__('Custom Form')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'approve_agent_verification')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('agent-verification.index')); ?>"><?php echo e(__('Agent Verification List')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'property')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('property')); ?>" class='sidebar-link'>
                            <i class="bi bi-building"></i>
                            <span class="menu-item"><?php echo e(__('Property')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'city_images')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(route('city-images.index')); ?>" class='sidebar-link'>
                            <i class="bi bi-image-alt"></i>
                            <span class="menu-item"><?php echo e(__('City Images')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'project')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('project')); ?>" class='sidebar-link'>
                        <i class="bi bi-house"></i>
                            <span class="menu-item"><?php echo e(__('Project')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'report_reason')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('report-reasons')); ?>" class='sidebar-link'>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-list">
                                <line x1="8" y1="6" x2="21" y2="6"></line>
                                <line x1="8" y1="12" x2="21" y2="12"></line>
                                <line x1="8" y1="18" x2="21" y2="18"></line>
                                <line x1="3" y1="6" x2="3.01" y2="6"></line>
                                <line x1="3" y1="12" x2="3.01" y2="12"></line>
                                <line x1="3" y1="18" x2="3.01" y2="18"></line>
                            </svg>
                            <span class="menu-item"><?php echo e(__('Report Reasons')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'user_reports')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('users_reports')); ?>" class='sidebar-link'>
                            <i class="bi bi-exclamation-octagon-fill"></i>
                            <span class="menu-item"><?php echo e(__('Users Reports')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'users_inquiries')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('users_inquiries')); ?>" class='sidebar-link'>
                            <i class="fas fa-question-circle"></i>
                            <span class="menu-item"><?php echo e(__('Users Inquiries')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'chat')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(route('get-chat-list')); ?>" class='sidebar-link'>
                            <i class="bi bi-chat"></i>
                            <span class="menu-item"><?php echo e(__('Chat')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'slider')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('slider')); ?>" class='sidebar-link'>
                            <i class="bi bi-sliders"></i>
                            <span class="menu-item"><?php echo e(__('Slider')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'article')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('article')); ?>" class='sidebar-link'>
                            <i class="bi bi-vector-pen"></i>
                            <span class="menu-item"><?php echo e(__('Article')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'advertisement')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('featured_properties')); ?>" class='sidebar-link'>
                            <i class="bi bi-badge-ad"></i>
                            <span class="menu-item"><?php echo e(__('Advertisement')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'package')): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-credit-card-2-back"></i>
                            <span class="menu-item"><?php echo e(__('Feature Packages')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'package-feature') || has_permissions('create', 'package-feature')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('package-features.index')); ?>"><?php echo e(__('Features')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'package') || has_permissions('create', 'package')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('package.index')); ?>"><?php echo e(__('Packages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'user_package')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('user-packages.index')); ?>"><?php echo e(__('Users Packages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'payment')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('payment.index')); ?>"><?php echo e(__('Payment')); ?></a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'calculator')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('calculator')); ?>" class='sidebar-link'>
                            <i class="bi bi-calculator"></i>
                            <span class="menu-item"><?php echo e(__('Calculator')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'notification')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('notification')); ?>" class='sidebar-link'>
                            <i class="bi bi-bell"></i>
                            <span class="menu-item"><?php echo e(__('Notification')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'faqs')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(route('faqs.index')); ?>" class='sidebar-link'>
                            <i class="bi bi-question-circle"></i>
                            <span class="menu-item"><?php echo e(__('FAQ')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'homepage-sections')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(route('homepage-sections.index')); ?>" class='sidebar-link'>
                            <i class="bi bi-house-fill"></i>
                            <span class="menu-item"><?php echo e(__('Homepage Sections')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'users_accounts') ||
                        has_permissions('read', 'about_us') ||
                        has_permissions('read', 'privacy_policy') ||
                        has_permissions('read', 'terms_conditions') ||
                        has_permissions('read', 'web_settings') ||
                        has_permissions('read', 'language') ||
                        has_permissions('read', 'app_settings')): ?>

                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-gear"></i>
                            <span class="menu-item"><?php echo e(__('Settings')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">

                            
                            <?php if(has_permissions('read', 'users_accounts')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('users')); ?>"><?php echo e(__('Users Accounts')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'about_us')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('about-us')); ?>"><?php echo e(__('About Us')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'privacy_policy')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('privacy-policy')); ?>"><?php echo e(__('Privacy Policy')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'terms_conditions')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('terms-conditions')); ?>"><?php echo e(__('Terms & Condition')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'language')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('language')); ?>"><?php echo e(__('Languages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'system_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('system-settings')); ?>"><?php echo e(__('System Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'app_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('app-settings')); ?>"><?php echo e(__('App Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'web_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('web-settings')); ?>"><?php echo e(__('Web Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'seo_setting')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('seo_settings')); ?>"><?php echo e(__('SEO Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'firebase_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('firebase_settings')); ?>"><?php echo e(__('Firebase Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'notification_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('notification-setting-index')); ?>"><?php echo e(__('Notification Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'email_configurations')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('email-configurations-index')); ?>"><?php echo e(__('Email Configurations')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'email_templates')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('email-templates.index')); ?>"><?php echo e(__('Email Templates')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'system_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('log-viewer')); ?>"><?php echo e(__('Log Viewer')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>

                    
                    <?php if(has_permissions('read', 'system_update')): ?>
                        <li class="sidebar-item">
                            <a href="<?php echo e(url('system-version')); ?>" class='sidebar-link'>
                                <i class="fas fa-cloud-download-alt"></i>
                                <span class="menu-item"><?php echo e(__('System Update')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH /home/wrteam-shakir/ebroker/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>