<?php $__env->startSection('title'); ?>
    <?php echo e(__('Property')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"> </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="card">
            <?php if(has_permissions('create', 'property')): ?>
                <div class="card-header">
                    <div class="row ">
                        
                        <div class="col-12 col-xs-12 d-flex justify-content-end">
                            <?php echo Form::open(['route' => 'property.create']); ?>

                            <?php echo e(method_field('get')); ?>

                            <?php echo e(Form::submit(__('Add Property'), ['class' => 'btn btn-primary'])); ?>

                            <?php echo Form::close(); ?>

                        </div>

                    </div>
                </div>
            <?php endif; ?>

            <hr>
            <div class="card-body">
                <div class="row" id="toolbar">
                    
                    <div class="col-xl-3 mt-2">
                        <select class="form-select form-control-sm" id="filter_category">
                            <option value=""><?php echo e(__('Select Category')); ?></option>
                            <?php if(isset($category)): ?>
                                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->category); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    
                    <div class="col-xl-3 mt-2">
                        <select id="status" class="form-select form-control-sm">
                            <option value=""><?php echo e(__('Select Status')); ?> </option>
                            <option value="0"><?php echo e(__('Inactive')); ?></option>
                            <option value="1"><?php echo e(__('Active')); ?></option>
                        </select>
                    </div>
                    
                    <div class="col-xl-3 mt-2">
                        <select id="property-type-filter" class="form-select form-control-sm">
                            <option value=""><?php echo e(__('Select Type')); ?> </option>
                            <option value="0"><?php echo e(__('Sale')); ?></option>
                            <option value="1"><?php echo e(__('Rent')); ?></option>
                            <option value="2"><?php echo e(__('Sold')); ?></option>
                            <option value="3"><?php echo e(__('Rented')); ?></option>
                        </select>
                    </div>
                    
                    <div class="col-xl-3 mt-2">
                        <select id="property-owner-filter" class="form-select form-control-sm">
                            <option value=""><?php echo e(__('Select Property Owner')); ?> </option>
                            <option value="0"><?php echo e(__('By Admin')); ?></option>
                            <option value="1"><?php echo e(__('By Users')); ?></option>
                        </select>
                    </div>
                    
                    <div class="col-xl-3 mt-2">
                        <select id="property-accessibility-filter" class="form-select form-control-sm">
                            <option value=""><?php echo e(__('Select Accessibility Type')); ?> </option>
                            <option value="0"><?php echo e(__('All')); ?></option>
                            <option value="1"><?php echo e(__('Private')); ?></option>
                            <option value="2"><?php echo e(__('General')); ?></option>
                        </select>
                    </div>

                </div>

                <div class="row">
                    <div class="col-12">
                        <table class="table table-striped"
                            id="table_list" data-toggle="table" data-url="<?php echo e(url('getPropertyList')); ?>"
                            data-click-to-select="true" data-side-pagination="server" data-pagination="true"
                            data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-search-align="right"
                            data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true"
                            data-trim-on-search="false" data-responsive="true" data-sort-name="id" data-sort-order="desc"
                            data-pagination-successively-size="3" data-query-params="queryParams">
                            <thead class="thead-dark">
                                <tr>
                                    <th scope="col" data-field="id" data-align="center" data-sortable="true"> <?php echo e(__('ID')); ?></th>
                                    <th scope="col" data-field="added_by" data-align="center" data-sortable="false"> <?php echo e(__('Client Name')); ?></th>
                                    <th scope="col" data-field="mobile" data-align="center" data-sortable="false"> <?php echo e(__('Mobile')); ?> </th>
                                    <th scope="col" data-field="client_address" data-align="center" data-sortable="false"><?php echo e(__('Client Address')); ?></th>
                                    <th scope="col" data-field="title" data-sortable="false" class="max-width-row"><?php echo e(__('Title')); ?></th>
                                    <th scope="col" data-field="slug_id" data-visible="false" data-sortable="true" data-align="center"><?php echo e(__('Slug')); ?></th>
                                    <th scope="col" data-field="address" data-align="center" data-sortable="false"> <?php echo e(__('Address')); ?></th>
                                    <th scope="col" data-field="category.category" data-align="center" data-sortable="true"> <?php echo e(__('Category')); ?></th>
                                    <th scope="col" data-field="propery_type" data-formatter="propertyTypeFormatter" data-align="center" data-sortable="true"> <?php echo e(__('Type')); ?></th>
                                    <th scope="col" data-field="edit_status" data-sortable="false" data-align="center" data-width="5%" data-formatter="enableDisableSwitchFormatter"> <?php echo e(__('Enable/Disable')); ?></th>
                                    <th scope="col" data-field="status" data-align="center" data-sortable="false" data-formatter="statusFormatter"> <?php echo e(__('Status')); ?></th>
                                    <th scope="col" data-field="title_image" data-formatter="imageFormatter" data-align="center" data-sortable="false"> <?php echo e(__('Image')); ?></th>
                                    <th scope="col" data-field="three_d_image" data-formatter="imageFormatter" data-align="center" data-sortable="false"> <?php echo e(__('3D Image')); ?></th>
                                    <th scope="col" data-field="interested_users" data-align="center" data-sortable="false" data-events="actionEvents"> <?php echo e(__('Total Interested Users')); ?></th>
                                    <th scope="col" data-field="status" data-sortable="false" data-align="center" data-width="5%" data-formatter="yesNoStatusFormatter"> <?php echo e(__('Is Property Active ?')); ?></th>
                                    <th scope="col" data-field="request_status" data-sortable="false" data-align="center" data-width="5%" data-formatter="requestStatusFormatter"> <?php echo e(__('Status')); ?></th>
                                    <th scope="col" data-field="is_premium" data-formatter="premium_status_switch" data-align="center" data-sortable="false"> <?php echo e(__('Private/Public')); ?></th>
                                    <th scope="col" data-field="gallery-images-btn" data-align="center" data-sortable="false" data-events="actionEvents"> <?php echo e(__('Gallery Images')); ?></th>
                                    <th scope="col" data-field="documents-btn" data-align="center" data-sortable="false" data-events="actionEvents"> <?php echo e(__('Documents')); ?></th>
                                    <th scope="col" data-field="video_link" data-sortable="false" data-align="center" data-formatter="videoLinkFormatter"> <?php echo e(__('Video Link')); ?></th>
                                    <?php if(has_permissions('update', 'property')): ?>
                                        <th scope="col" data-field="operate" data-align="center" data-sortable="false" data-events="actionEvents"> <?php echo e(__('Action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>

            </div>
        </div>

        
        <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1"
            aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title" id="myModalLabel1"><?php echo e(__('Interested Users')); ?></h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-striped" id="customer_table_list" data-toggle="table" data-url="<?php echo e(url('customerList')); ?>" data-click-to-select="true" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-show-columns="true" data-show-refresh="true" data-trim-on-search="false" data-responsive="true" data-sort-name="id" data-sort-order="desc" data-pagination-successively-size="3" data-query-params="customerqueryParams" data-show-export="true" data-export-options='{ "fileName": "data-list-<?= date(' d-m-y') ?>" }'>
                            <thead class="thead-dark">
                                <tr>
                                    <th scope="col" data-field="id" data-sortable="true" data-align="center"> <?php echo e(__('ID')); ?></th>
                                    <th scope="col" data-field="profile" data-sortable="false" data-align="center" data-formatter="imageFormatter"> <?php echo e(__('Profile')); ?></th>
                                    <th scope="col" data-field="name" data-sortable="true" data-align="center"> <?php echo e(__('Name')); ?></th>
                                    <th scope="col" data-field="mobile" data-sortable="true" data-align="center"> <?php echo e(__('Number')); ?></th>
                                    <th scope="col" data-field="email" data-sortable="false" data-align="center"> <?php echo e(__('Email')); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        


        
        <div id="galleryImagesModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="galleryImagesModalContent" aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title" id="galleryImagesModalContent"><?php echo e(__('Gallery Images')); ?></h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body gallary-images-div row">
                    </div>
                </div>

            </div>

        </div>
        

        
        <div id="documentsModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="documentsModalContent" aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title" id="documentsModalContent"><?php echo e(__('Documents')); ?></h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body documents-div row">
                    </div>
                </div>

            </div>

        </div>
        

        
        <div id="changeRequestStatusModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="changeRequestStatusModalContent" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title" id="changeRequestStatusModalContent"><?php echo e(__('Change Status')); ?></h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <form class="create-form" action="<?php echo e(route('update-property-request-status')); ?>" data-success-function="editFormSuccessFunction" method="POST">
                        <div class="modal-body">
                            <?php echo e(csrf_field()); ?>


                            <?php echo Form::hidden('id', "", ['id' => 'edit-request-status-id']); ?>

                            <div class="col-md-12 col-12  form-group  mandatory">
                                <div class="row">
                                    <?php echo e(Form::label('', __('Status'), ['class' => 'form-label col-12 '])); ?>


                                    
                                    <div class="col-md-3">
                                        <?php echo e(Form::radio('request_status', 'approved', null, [ 'class' => 'form-check-input request-status', 'id' => 'status-approve', 'required' => true ])); ?>

                                        <?php echo e(Form::label('status-approve', __('Approve'), ['class' => 'form-check-label'])); ?>

                                    </div>

                                    
                                    <div class="col-md-3">
                                        <?php echo e(Form::radio('request_status', 'rejected', null, [ 'class' => 'form-check-input request-status', 'id' => 'status-reject', 'required' => true, ])); ?>

                                        <?php echo e(Form::label('status-reject', __('Reject'), ['class' => 'form-check-label'])); ?>

                                    </div>

                                    
                                    <div class="col-12 mt-1 reject-reason-text-div form-group  mandatory" style="display: none">
                                        <?php echo e(Form::label('reject-reason-text', __('Reject Reason'), ['class' => 'form-label'])); ?>

                                        <?php echo Form::textarea('reject_reason', null, ["id" => "reject-reason-text", "class" => 'form-control', "placeholder" => trans('Reject Reason')]); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn-primary waves-effect waves-light" id="btn_submit"><?php echo e(__('Update')); ?></button>
                        </div>
                    </form>
                </div>

            </div>

        </div>
        

        <input type="hidden" id="property_id">

    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('#status').on('change', function() {
            $('#table_list').bootstrapTable('refresh');

        });

        $('#filter_category').on('change', function() {
            $('#table_list').bootstrapTable('refresh');

        });
        $('#property-type-filter').on('change', function() {
            $('#table_list').bootstrapTable('refresh');

        });
        $('#property-owner-filter').on('change', function() {
            $('#table_list').bootstrapTable('refresh');

        });
        $('#property-accessibility-filter').on('change', function() {
            $('#table_list').bootstrapTable('refresh');

        });


        $(document).ready(function() {
            var params = new window.URLSearchParams(window.location.search);
            if (params.get('status') != 'null') {
                $('#status').val(params.get('status')).trigger('change');
            }
            if (params.get('type') != 'null') {
                $('#type').val(params.get('type'));
            }
        });


        function queryParams(p) {

            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search,
                status: $('#status').val(),
                category: $('#filter_category').val(),
                property_type: $('#property-type-filter').val(),
                property_added_by: $('#property-owner-filter').val(),
                property_accessibility: $('#property-accessibility-filter').val(),
                customerID: "<?php echo e($customerID); ?>"
            };
        }

        window.actionEvents = {
            'click .edit_btn': function(e, value, row, index) {
                $('#property_id').val(row.id);
                $('#customer_table_list').bootstrapTable('refresh');
            },
            'click .gallery-image-btn': function(e, value, row, index) {
                $('.gallary-images-div').empty();
                if(row.gallery.length){
                    $.each(row.gallery, function(key, value) {
                        $('.gallary-images-div').append(
                            `<div class="col-sm-12 col-md-3 col-lg-2 mt-1 ml-1">
                                <a href="${value.image_url}" target="_blank">
                                    <img src="${value.image_url}"height="100" width="100" class="rounded"/>
                                </a>
                            </div>`
                        );
                    });
                }else{
                    $('.gallary-images-div').append(
                        `<span class="no-data-found-span">
                            ${window.trans["No Data Found"]}
                        </span>`
                    );
                }
            },
            'click .documents-btn': function(e, value, row, index) {
                $('.documents-div').empty();
                if(row.documents.length){
                    $.each(row.documents, function(key, value) {
                        var url = value.file; // Your URL
                        var filename = value.file_name;
                        var documentSvgImage = `<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="30" width="30" xmlns="http://www.w3.org/2000/svg"><path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M208 64h66.75a32 32 0 0122.62 9.37l141.26 141.26a32 32 0 019.37 22.62V432a48 48 0 01-48 48H192a48 48 0 01-48-48V304"></path><path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M288 72v120a32 32 0 0032 32h120"></path><path fill="none" stroke-linecap="round" stroke-miterlimit="10" stroke-width="32" d="M160 80v152a23.69 23.69 0 01-24 24c-12 0-24-9.1-24-24V88c0-30.59 16.57-56 48-56s48 24.8 48 55.38v138.75c0 43-27.82 77.87-72 77.87s-72-34.86-72-77.87V144"></path></svg>`;
                        var downloadImg = `<svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24" height="20" width="20" xmlns="http://www.w3.org/2000/svg"><path d="m12 16 4-5h-3V4h-2v7H8z"></path><path d="M20 18H4v-7H2v7c0 1.103.897 2 2 2h16c1.103 0 2-.897 2-2v-7h-2v7z"></path></svg>`;
                        var downloadText = "<?php echo e(__('Download')); ?>";

                        $('.documents-div').append(
                            `<div class="col-sm-12 col-md-6 col-lg-4 col-xl-3 col-xxl-3 mt-2 bg-light rounded m-2 p-2">
                                <div class="docs_main_div">
                                    <div class="doc_icon">
                                        ${documentSvgImage}
                                    </div>
                                    <div class="doc_title">
                                        <span title="${filename}">${filename}</span>
                                    </div>
                                    <div class="doc_download_button">
                                        <a href="${url}" target="_blank">
                                            <span>
                                                ${downloadImg}
                                            </span>
                                            <span>${downloadText}</span>
                                        </a>
                                    </div>
                                </div>
                            </div>`
                        );
                    });
                }else{
                    $('.documents-div').append(
                        `<span class="no-data-found-span">
                            ${window.trans["No Data Found"]}
                        </span>`
                    );
                }
            },
            'click .request-status-btn': function(e, value, row, index) {
                $("#edit-request-status-id").val(row.id);
                $('input[name=request_status]').prop('checked', false);
                $("#reject-reason-text").text("").removeAttr("required");
                $(".reject-reason-text-div").hide();
            }
        }

        function customerqueryParams(p) {

            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search,
                property_id: $('#property_id').val(),
            };
        }
        function editFormSuccessFunction () {
            $('#table_list').bootstrapTable('refresh');
            setTimeout(function () {
                $('#changeRequestStatusModal').modal('hide');
            }, 1000);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-shakir/ebroker/resources/views/property/index.blade.php ENDPATH**/ ?>