<?php $__env->startSection('title'); ?>
    <?php echo e(__('Email Templates')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="text-end m-2">
            <a href="<?php echo e(route('email-templates.index')); ?>" class="btn btn-primary"><?php echo e(__('Back')); ?></a>
        </div>
        <div class="page-header">
            <h3 class="page-title">
                <?php echo e(__('Email Templates')); ?>

            </h3>
        </div>
        <div class="row grid-margin">
            <div class="col-lg-12">
                <div class="card">
                    <form class="create-form" action="<?php echo e(route('email-templates.store')); ?>" method="POST" data-success-function="formSuccessFunction">
                        <div class="card-body">
                            <?php echo csrf_field(); ?>
                            <?php echo Form::hidden('type', $data['type']); ?>

                            <div class="form-group">
                                <label><?php echo e(trans($data['title'])); ?> <span class="text-danger">*</span></label>
                                <div class="form-group col-md-12 col-sm-12">
                                    <textarea class="tinymce_editor" name="data" class="form-control email-template col-md-7 col-xs-12"><?php echo e($data['template']); ?></textarea>
                                </div>
                                <div class="form-group col-sm-12 col-md-12">
                                    <?php $__currentLoopData = $data['required_fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($field['is_condition']): ?>
                                            <a data-value="<?php echo e("{".$field['name']."}"); ?>|<?php echo e("{end_".$field['name']."}"); ?>" class="btn btn-light btn_tag mt-2" data-is-condition="true"><?php echo e("{".$field['name']."}"); ?></a>
                                        <?php else: ?>
                                            <a data-value="<?php echo e("{".$field['name']."}"); ?>" class="btn btn-light btn_tag mt-2" data-is-condition="false"><?php echo e("{".$field['name']."}"); ?></a>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <div class="col-12 mt-2 d-flex justify-content-end">
                                <button class="btn btn-primary me-1 mb-1" type="submit" name="submit"><?php echo e(__('Save')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>

        function queryParams(p) {
            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search
            };
        }

        $('.btn_tag').click(function (e) {
            e.preventDefault();
            var value = `<b>${$(this).data('value')}</b>`;
            var isCondition = $(this).data('is-condition');

            if (tinymce.activeEditor) { // Check if editor is active
                if (isCondition) {
                    var values = value.split('|');

                    var combinedValue = values[0] + '<span id="cursorMarker"></span>' + values[1];

                    tinymce.activeEditor.insertContent(combinedValue);

                    // Move the cursor to the position between the split values
                    var editor = tinymce.activeEditor;
                    var marker = editor.getBody().querySelector('#cursorMarker');
                    if (marker) {
                        var range = document.createRange();
                        var selection = editor.selection;

                        range.setStartAfter(marker);
                        range.setEndAfter(marker);

                        selection.setRng(range);
                        marker.remove();
                    }
                } else {
                    tinymce.activeEditor.insertContent(value);
                }
            } else {
                alert('TinyMCE editor not active');
            }
        });



        function formSuccessFunction(response) {
            if(!response.error){
                setTimeout(() => {
                    window.location.reload();
                }, 500);
            }
        }
        // Load
        window.onload = setTimeout(() => {
            $('.email-template').trigger('change');
        }, 500);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-shakir/ebroker/resources/views/mail-templates/templates-settings/update-template.blade.php ENDPATH**/ ?>