<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Agent Verification')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"> </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <a href="<?php echo e(route('agent-verification.index')); ?>" class="btn btn-primary"><?php echo e(__('Back')); ?></a>
        <div class="card mt-3">
            <div class="card-header">
                <div class="divider">
                    <div class="divider-text">
                        <h4><?php echo e(__('Agent Details')); ?></h4>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        
                        <div class="col-lg-4">
                            <?php echo e(Form::label('agnet-id', __('Agent Id'), ['class' => 'form-label text-center'])); ?>

                            <?php echo e(Form::text('agnet-id', $customerVerification->user->id, [ 'class' => 'form-control', 'placeholder' => trans('Question'),'readonly','disabled' => true])); ?>

                        </div>

                        
                        <div class="col-lg-4">
                            <?php echo e(Form::label('agnet-name', __('Agent Name'), ['class' => 'form-label text-center'])); ?>

                            <?php echo e(Form::text('agnet-name', $customerVerification->user->name, [ 'class' => 'form-control', 'placeholder' => trans('Question'),'readonly','disabled' => true])); ?>

                        </div>

                        
                        <div class="col-lg-4">
                            <?php echo e(Form::label('verification-status', __('Verification Status'), ['class' => 'form-label d-block'])); ?>

                            <?php
                                if($customerVerification->status == 'success'){
                                    $btnClass = 'btn btn-success';
                                }else if($customerVerification->status == 'failed'){
                                    $btnClass = 'btn btn-danger';
                                } else {
                                    $btnClass = 'btn btn-warning';
                                }
                            ?>
                            <?php echo e(Form::text('verification-status', ucfirst($customerVerification->status), [ 'class' => $btnClass, 'placeholder' => trans('Question'),'readonly','disabled' => true])); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card mt-3">
            <div class="card-header">
                <div class="divider">
                    <div class="divider-text">
                        <h4><?php echo e(__('Form Details')); ?></h4>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $customerVerification->verify_customer_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerFormValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4">
                                <?php switch($customerFormValue['verify_form']['field_type']):
                                    case ('text'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <input type="text" class="form-control" value="<?php echo e($customerFormValue['value']); ?>" disabled>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('textarea'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <textarea class="form-control" disabled><?php echo e($customerFormValue['value']); ?></textarea>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('number'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <input type="number" class="form-control" value="<?php echo e($customerFormValue['value']); ?>" disabled>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('checkbox'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <?php $__currentLoopData = $customerFormValue['verify_form']['form_fields_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <input type="checkbox" class="form-check-input"
                                                    <?php if(in_array($option->value, $customerFormValue->value)): ?>
                                                        checked
                                                    <?php endif; ?>
                                                    disabled><?php echo e($option->value); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('dropdown'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <select class="form-select form-control-sm" disabled>
                                                <?php $__currentLoopData = $customerFormValue['verify_form']['form_fields_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($option->value); ?>" <?php echo e($customerFormValue->value == $option->value ? 'selected' : ''); ?>><?php echo e($option->value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('radio'): ?>
                                        <div class="form-group">
                                            <label><?php echo e($customerFormValue['verify_form']['name']); ?></label>
                                            <?php $__currentLoopData = $customerFormValue['verify_form']['form_fields_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="form-check">
                                                    <input type="radio" class="form-check-input" name="<?php echo e($customerFormValue['verify_form']['name']); ?>" value="<?php echo e($option->value); ?>" <?php echo e($customerFormValue['value'] == $option->value ? 'checked' : ''); ?> disabled>
                                                    <label class="form-check-label"><?php echo e($option->value); ?></label>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php break; ?>

                                    <?php case ('file'): ?>
                                        <?php switch($customerFormValue['file_type']):
                                        case ('image'): ?>
                                            <div class="form-group">
                                                <label><?php echo e($customerFormValue['verify_form']['name']); ?> :- </label>
                                                <?php if(!empty($customerFormValue['value'])): ?>
                                                    <a href="<?php echo e($customerFormValue['value']); ?>" target="_blank"><?php echo e(__('File')); ?></a>
                                                <?php endif; ?>
                                            </div>
                                            <?php break; ?>

                                        <?php case ('pdf'): ?>
                                        <?php case ('txt'): ?>
                                        <?php case ('doc'): ?>
                                        <?php case ('docx'): ?>
                                            <div class="form-group">
                                                <label><?php echo e($customerFormValue['verify_form']['name']); ?> :- </label>
                                                <?php if(!empty($customerFormValue['value'])): ?>
                                                    <a href="<?php echo e($customerFormValue['value']); ?>" target="_blank" download><?php echo e(__('Download File')); ?></a>
                                                <?php endif; ?>
                                            </div>
                                            <?php break; ?>
                                        <?php endswitch; ?>
                                    <?php default: ?>
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-shakir/ebroker/resources/views/verify-customer-form/view-form-details.blade.php ENDPATH**/ ?>