<?php $__env->startSection('title'); ?>
    <?php echo e(__('FAQ')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"> </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="section">
        
        <div class="card add-category mt-3">
            <div class="card-header">
                <div class="divider">
                    <div class="divider-text">
                        <h4><?php echo e(__('Create FAQ')); ?></h4>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <?php echo Form::open(['url' => route('faqs.store'), 'data-parsley-validate', 'class' => 'create-form']); ?>

                        <div class=" row">

                            
                            <div class="col-lg-12 col-xl-6 form-group mandatory">
                                <?php echo e(Form::label('question', __('Question'), ['class' => 'form-label text-center'])); ?>

                                <?php echo e(Form::textarea('question', '', [ 'class' => 'form-control', 'placeholder' => trans('Question'), 'data-parsley-required' => 'true', 'id' => 'question', 'rows' => 2])); ?>

                            </div>

                            
                            <div class="col-lg-12 col-xl-6 form-group mandatory">
                                <?php echo e(Form::label('answer', __('Answer'), ['class' => 'form-label text-center'])); ?>

                                <?php echo e(Form::textarea('answer', '', [ 'class' => 'form-control', 'placeholder' => trans('Answer'), 'data-parsley-required' => 'true', 'id' => 'answer', 'rows' => 2])); ?>

                            </div>

                            
                            <div class="col-sm-12 col-md-12 text-end" style="margin-top:2%;">
                                <?php echo e(Form::submit('Save', ['class' => 'btn btn-primary me-1 mb-1'])); ?>

                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>

    </section>

    <section class="section">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <table class="table table-striped"
                            id="table_list" data-toggle="table" data-url="<?php echo e(route('faqs.show',1)); ?>"
                            data-click-to-select="true" data-responsive="true" data-side-pagination="server"
                            data-pagination="true" data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                            data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true"
                            data-trim-on-search="false" data-sort-name="id" data-sort-order="desc"
                            data-pagination-successively-size="3" data-query-params="queryParams">
                            <thead class="thead-dark">
                                <tr>
                                    <th scope="col" data-field="id" data-sortable="true" data-align="center"><?php echo e(__('ID')); ?></th>
                                    <th scope="col" data-field="question" data-sortable="true"><?php echo e(__('Question')); ?></th>
                                    <th scope="col" data-field="answer" data-sortable="true"><?php echo e(__('Answer')); ?></th>
                                    <th scope="col" data-field="status" data-sortable="false" data-align="center" data-width="5%" data-formatter="enableDisableSwitchFormatter"> <?php echo e(__('Enable/Disable')); ?></th>
                                    <th scope="col" data-field="operate" data-sortable="false" data-align="center" data-events="actionEvents"> <?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </section>

    <!-- EDIT MODEL MODEL -->
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="FaqEditModal"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="FaqEditModal"><?php echo e(__('Edit FAQ')); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal edit-form" action="<?php echo e(url('faqs')); ?>" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" id="edit-id" name="edit_id">
                        
                        <div class="col-lg-12 form-group">
                            <?php echo e(Form::label('edit-question', __('Question'), ['class' => 'form-label text-center'])); ?>

                            <?php echo e(Form::textarea('edit_question', '', [ 'class' => 'form-control', 'placeholder' => trans('Question'), 'required' => true, 'id' => 'edit-question', 'rows' => 2])); ?>

                        </div>

                        
                        <div class="col-lg-12 form-group">
                            <?php echo e(Form::label('edit-answer', __('Answer'), ['class' => 'form-label text-center'])); ?>

                            <?php echo e(Form::textarea('edit_answer', '', [ 'class' => 'form-control', 'placeholder' => trans('Answer'), 'required' => true, 'id' => 'edit-answer', 'rows' => 2])); ?>

                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light" id="btn_submit"><?php echo e(__('Save')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- EDIT MODEL -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    
    <script src=https://bevacqua.github.io/dragula/dist/dragula.js></script>
    <script>
        function queryParams(p) {
            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search
            };
        }

        window.actionEvents = {
            'click .edit_btn': function(e, value, row, index) {
                $("#edit-id").val(row.id);
                $("#edit-question").val(row.question);
                $("#edit-answer").val(row.answer);
            }
        }


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-shakir/ebroker/resources/views/faqs/index.blade.php ENDPATH**/ ?>