<?php $__env->startSection('title'); ?>
    <?php echo e(__('Notification Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo e(__('Notification Settings')); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <form class="form" action="<?php echo e(route('notification-setting-store')); ?>" method="POST" enctype="multipart/form-data" data-parsley-validate>
            <?php echo e(csrf_field()); ?>

            <div class="row">
                <div class="col-sm-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        
                                        <?php if(empty($firebaseProjectId)): ?>
                                            <div class="col-sm-12 col-lg-6 form-group mandatory">
                                                <?php echo e(Form::label('project-id', __('Project ID') , ['class' => 'form-label'])); ?>

                                                <?php echo Form::text('firebase_project_id', ($firebaseProjectId != '' ? $firebaseProjectId : ''), ['class' => 'form-control', 'placeholder' => __('Project ID'), 'id' => 'project-id', 'data-parsley-required' => 'true']); ?>

                                            </div>
                                        <?php else: ?>
                                            <div class="col-sm-12 col-lg-6 form-group">
                                                <?php echo e(Form::label('project-id', __('Project ID') , ['class' => 'form-label'])); ?>

                                                <?php echo Form::text('firebase_project_id', ($firebaseProjectId != '' ? $firebaseProjectId : ''), ['class' => 'form-control', 'placeholder' => __('Project ID'), 'id' => 'project-id']); ?>

                                            </div>
                                        <?php endif; ?>

                                        
                                        <?php if(empty($firebaseServiceJsonFile)): ?>
                                            <div class="col-sm-12 col-lg-6 form-group mandatory">
                                                <?php echo e(Form::label('service-json-file', __('Service JSON File'), ['class' => 'form-label'])); ?>

                                                <?php echo e(Form::file('firebase_service_json_file', ['class' => 'form-control', 'data-parsley-required' => 'true', 'accept' => '.json', 'required' => true])); ?>

                                            </div>
                                        <?php else: ?>
                                            <div class="col-sm-12 col-lg-6 form-group">
                                                <?php echo e(Form::label('service-json-file', __('Service JSON File'), ['class' => 'form-label'])); ?>

                                                <?php echo e(Form::file('firebase_service_json_file', ['class' => 'form-control', 'accept' => '.json'])); ?>

                                                <div class="mt-2">
                                                    <span class="alert-info rounded text-sm p-2"><?php echo e(__('File Exists')); ?></span>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 d-flex justify-content-end">
                <button type="submit" name="btnAdd1" value="btnAdd" id="btnAdd1" class="btn btn-primary me-1 mb-1"><?php echo e(__('Save')); ?></button>
            </div>
        </form>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u357030340/domains/lucidinnovation.net/public_html/placeholder/resources/views/settings/notification-settings.blade.php ENDPATH**/ ?>