<?php $__env->startSection('title'); ?>
    <?php echo e(__('Email Configurations')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo e(__('Email Configurations')); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php echo Form::open(['url' => route('email-configurations-store'), 'data-parsley-validate', 'class' => 'create-form', 'data-success-function'=> "formSuccessFunction"]); ?>

            <div class="row">
                <div class="col-sm-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12 col-md-6 order-md-1">
                                            <h5><?php echo e(__('Update Configurations')); ?></h5>
                                        </div>
                                    </div>
                                    <div class="row mt-4">
                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-mailer"><?php echo e(__('Mailer')); ?></label>
                                            <select required name="mail_mailer" id="mail-mailer" class="form-control select2" style="width:100%;" tabindex="-1" aria-hidden="true">
                                                <option value=""><?php echo e(__("Select Mailer")); ?></option>
                                                <option <?php echo e(env('MAIL_MAILER')=='smtp' ?'selected':''); ?> value="smtp">SMTP</option>
                                                <option <?php echo e(env('MAIL_MAILER')=='sendmail' ?'selected':''); ?> value="sendmail">sendmail</option>
                                                <option <?php echo e(env('MAIL_MAILER')=='amazon_ses' ?'selected':''); ?> value="amazon_ses">Amazon SES</option>
                                            </select>
                                        </div>

                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-host"><?php echo e(__('Mail Host')); ?></label>
                                            <input name="mail_host" id="mail-host" value="<?php echo e(env('MAIL_HOST')); ?>" type="text" required placeholder="<?php echo e(__('Mail Host')); ?>" class="form-control"/>
                                        </div>

                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-port"><?php echo e(__('Mail Port')); ?></label>
                                            <input name="mail_port" id="mail-port" value="<?php echo e(env('MAIL_PORT')); ?>" type="text" required placeholder="<?php echo e(__('Mail Port')); ?>" class="form-control"/>
                                        </div>

                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-username"><?php echo e(__('Mail Username')); ?></label>
                                            <input name="mail_username" id="mail-username" value="<?php echo e(env('MAIL_USERNAME')); ?>" type="text" required placeholder="<?php echo e(__('Mail Username')); ?>" class="form-control"/>
                                        </div>

                                        
                                        <div class="form-group position-relative mb-4 col-md-4" id="pwd">
                                            <label for="mail-password"><?php echo e(__('Mail Password')); ?></label>
                                            <input id="mail-password" type="password" value="<?php echo e(env('MAIL_PASSWORD')); ?>" name="mail_password" placeholder="<?php echo e(__('Password')); ?>" class="form-control form-input" required>
                                            <div class="form-control-icon eye-icon">
                                                <i class="bi bi-eye" id='toggle_pass'></i>
                                            </div>
                                        </div>


                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-encryption"><?php echo e(__('Mail Encryption')); ?></label>
                                            <input name="mail_encryption" id="mail-encryption" value="<?php echo e(env('MAIL_ENCRYPTION')); ?>" type="text" required placeholder="<?php echo e(__('Mail Encryption')); ?>" class="form-control"/>
                                        </div>

                                        
                                        <div class="form-group col-md-4 col-sm-12">
                                            <label for="mail-send-from"><?php echo e(__('Mail Send From')); ?></label>
                                            <input name="mail_send_from" id="mail-send-from" value="<?php echo e(env('MAIL_FROM_ADDRESS')); ?>" type="text" required placeholder="<?php echo e(__('Mail Send From')); ?>" class="form-control"/>
                                        </div>
                                    </div>

                                    
                                    <div class="col-12 d-flex mt-4">
                                        <button type="submit" name="btnAdd1" value="btnAdd" id="btnAdd1" class="btn btn-primary me-1 mb-1"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php echo Form::close(); ?>

    </section>

    
    <section class="section">
        <div class="row grid-margin">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 order-md-1">
                                <h5><?php echo e(__('Email Configuration Verification')); ?></h5>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <form class="verify_email create-form" action="<?php echo e(route('verify-email-config')); ?>" method="POST" data-success-function="formSuccessFunction">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group col-md-6 col-lg-4">
                                    <label><?php echo e(__('Email')); ?></label>
                                    <input name="verify_email" type="email" required placeholder="<?php echo e(__('Email')); ?>" class="form-control" />
                                </div>
                                
                                <div class="form-group col-md-4">
                                    <input class="btn btn-primary" type="submit" value="<?php echo e(trans('Verify')); ?>">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $('#pwd').click(function() {
        $('#password').focus();
    });

    $("#toggle_pass").click(function() {
        $(this).toggleClass("bi bi-eye bi-eye-slash");
        var input = $('[name="mail_password"]');
        if (input.attr("type") == "password") {
            input.attr("type", "text");
        } else {
            input.attr("type", "password");
        }
    });

    function formSuccessFunction(response) {
        if(!response.error && !response.warning){
            setTimeout(() => {
                window.location.reload();
            }, 500);
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u357030340/domains/lucidinnovation.net/public_html/placeholder/resources/views/settings/email-configurations.blade.php ENDPATH**/ ?>